% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.not}
\alias{residuals.not}
\title{Extract residuals from a 'not' object}
\usage{
\method{residuals}{not}(object, cpt, type = c("raw", "standardised"),
  ...)
}
\arguments{
\item{object}{An object of class 'not', returned by \code{\link{not}}.}

\item{cpt}{An integer vector with locations of the change-points.
If missing, the \code{\link{features}} is called internally to extract the change-points from \code{object}.}

\item{type}{Choice of "raw" and "standardised".}

\item{...}{Further parameters that can be passed to \code{\link{predict.not}} and \code{\link{features}}.}
}
\value{
If \code{type="raw"}, the difference between the data and the estimated signal. If \code{type="standardised"}, the difference between the data and the estimated signal, divided by the estimated standard deviation.
}
\description{
Returns a difference between \code{x} in \code{object} and the estimated signal with change-points at \code{cpt}.
Type of the signal depends on the value of \code{contrast} that has been passed to \code{\link{not}} in order to construct \code{object} (see details of \code{\link{predict.not}}).
}
\examples{
pcws.const.sig <- c(rep(0, 100), rep(1,100))
x <- pcws.const.sig + rnorm(100)
w <- not(x, contrast = "pcwsConstMean")
# *** plot residuals obtained via fitting piecewise-constant function with estimated change-points
plot(residuals(w))
# *** plot residuals with obtained via fitting piecewise-constant function with true change-point
plot(residuals(w, cpt=100))
# *** plot standardised residuals
plot(residuals(w, type="standardised"))
}
