% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm.R
\name{dfm}
\alias{dfm}
\title{Estimating a dynamic factor model using the EM method.}
\usage{
dfm(data, blocks = NA, p = 1, max_iter = 5000, threshold = 1e-05)
}
\arguments{
\item{data}{matrix of variables, size (n_obs, n_variables). Must include in 1st column a series of type date, called "date", all data already stationary.}

\item{blocks}{Dataframe, size (n_variables, n_blocks). Note don't include date column in n_variables. Matrix of 1s or 0s for block loadings, i.e. 1 = included in block. Default is one global block containing all variables.}

\item{p}{number of lags in transition equation (AR element)}

\item{max_iter}{maximum number of iterations for EM (if no convergence)}

\item{threshold}{threshold for convergence of EM loop}
}
\value{
A \code{list} containing the following elements:
\item{Xsmooth_std}{standardized Kalman-smoothed data where missing values are replaced by their expectation}
\item{Xsmooth}{Kalman-smoothed data where missing values are replaced by their expectation. In original input units.}
\item{Z}{smoothed states, rows give time, and columns are organized according to matrix C.}
\item{C}{measurement matrix, rows correspond to each series, and the columns are organized as, columns 1-20 give the factor loadings. For example, 1-5 give loadings for the first, and are organized in reverse-chronological order (f^G_t, f^G_t-1, f^G_t-2, f^G_t-3, f^G_t-4), Columns 6-10, 11-15, and 16-20 give loadings for the second, third, and fourth blocks respectively.}
\item{R}{covariance for measurement matrix residuals.}
\item{A}{transition matrix, a square matrix that follows the same organization scheme as matrix C's columns. Identity matrices are used to account for matching terms on the left and righthand side. For example, we place an I4 matrix to account for matching (f_t-1; f_t-2; f_t-3; f_t-4) terms.}
\item{Q}{covariance for transition equation residuals}
\item{means}{means of each column.}
\item{sdevs}{standard deviations of each column.}
\item{Z0}{initial value of state.}
\item{V0}{initial value of covariance matrix}
\item{p}{number of lags in transition equation (AR element).}
\item{model}{names of features input to the model.}
\item{blocks}{same as parameter passed in.}
\item{num_vars}{number of features estimated in the model.}
\item{num_iter}{number of iterations for log likelihood to converge or hit maximum.}
\item{convergence}{1 if algorithm converged successfully (given max_iter).}
\item{loglik}{log likelihood of last iteration.}
\item{LL}{sequence of log likelihoods per iteration.}
\item{data}{data passed to the model.}
}
\description{
Runs a DFM for the nowcast model on the transformed data at a certain data vintage. Your data may not be able to be estimated on due to issues with invertible matrices, etc. If you get errors like "non-invertible" or "not a matrix", try reordering the columns in your dataframe, or adding or removing variables from it. It uses an implementation through the EM algorithm. It relies on several functions to determine initial values, calculate the nowcaKF, the sequence of steps of the EM algorithm and criteria to determine convergence.
}
