% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nowcast.plot.R
\name{nowcast.plot}
\alias{nowcast.plot}
\title{Plot for the nowcast output function}
\usage{
nowcast.plot(out, type = "fcst")
}
\arguments{
\item{out}{output of the nowcast function.}

\item{type}{'fcst', 'factors', 'eigenvalues' or 'eigenvectors'. The 'eigenvalues' and 'eigenvectors' options are only available for the two stages methods.}
}
\description{
Make plots to visualize the output of the nowcast function
}
\examples{
\dontrun{
data <- Bpanel(base = USGDP$base,
               trans = USGDP$legend$Transformation,
               aggregate = FALSE)
frequency <- c(rep(12, ncol(data) -1), 4)
now2s_agg <- nowcast(formula = RGDPGR ~ ., data = data, r = 2, p = 2, q = 2, 
                     method = '2s_agg', frequency = frequency)

nowcast.plot(now2s_agg, type = "fcst")
nowcast.plot(now2s_agg, type = "factors")
nowcast.plot(now2s_agg, type = "eigenvalues")
nowcast.plot(now2s_agg, type = "eigenvectors")
}
}
