% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npdeControl.R
\name{npdeControl}
\alias{npdeControl}
\alias{replace.control.options}
\alias{check.control.options}
\title{Set options for an NpdeObject}
\usage{
npdeControl(boolsave = TRUE, namsav = "output", type.graph = "eps",
verbose = FALSE, calc.npde = TRUE, calc.npd = TRUE, decorr.method = "cholesky",
cens.method = "omit", ties = TRUE, sample = FALSE)

check.control.options(opt)

replace.control.options(opt,...)

replace.control.options(opt, ...)

check.control.options(opt)
}
\arguments{
\item{boolsave}{whether to save the results (a file containing the numerical results and a file with the graphs)}

\item{namsav}{the root name of the files to save to (the file with the results will be named ROOTNAME.npde and the graphs will be saved to ROOTNAME.format where format is given by the type.graph argument)}

\item{type.graph}{type of graph to save to (one of "eps", "pdf", "jpeg", "png")}

\item{verbose}{a boolean; if TRUE, a message is printed as the computation of the npde begins for each new subject}

\item{calc.npde}{a boolean; TRUE to compute npde}

\item{calc.npd}{a boolean; TRUE to compute npd}

\item{decorr.method}{the method used to decorrelate simulated and observed data (see \code{\link{npde.decorr.method}})}

\item{cens.method}{the method used to handle censored data (see \code{\link{npde.cens.method}})}

\item{ties}{if FALSE, a smoothing will be applied to prediction discrepancies to avoid ties}

\item{sample}{if TRUE, the test on the pd will be performed after randomly sampling only pd per subject}

\item{opt}{a list of control options to be checked}

\item{...}{named parameters to be changed. The names will be compared to the names of the control variables and changed, with warnings issued for names that do not match.}
}
\value{
A list of settings for the computation of pd/npde
}
\description{
Set, replace and check options for an NpdeObject
}
\keyword{methods}
