% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNpde-methods.R
\name{plot.NpdeObject}
\alias{plot.NpdeObject}
\alias{plot.npde}
\alias{plotNpde}
\title{Plots a NpdeObject object}
\usage{
\method{plot}{NpdeObject}(x, y, ...)
}
\arguments{
\item{x}{a NpdeObject object}

\item{y}{unused, here for compatibility with the base plot function}

\item{\dots}{additional graphical parameters, which when given will supersede graphical preferences stored in the object}
}
\value{
a ggplot object or a list of ggplot objects (grobs)
}
\description{
Plots the data and diagnostic plots in a NpdeObject object
}
\details{
The default plots are represented as a 2x2 array with distribution plots on the top row (histogram and QQ-plot),
 and scatterplots of npde versus independent variable and population predictions on the bottom row. 
The graph is plotted in a graphic device window, unless the result is stored in an object (eg myplot<-plot(x)) which can then be printed (eg using print(myplot)).

 @references K. Brendel, E. Comets, C. Laffont, C. Laveille, and F.Mentre. Metrics for external model evaluation with an application to the population pharmacokinetics of gliclazide. \emph{Pharmaceutical Research}, 23:2036--49, 2006.
}
\examples{
\donttest{
data(theopp)
data(simtheopp)

x<-autonpde(theopp,simtheopp,iid="ID",ix="Time", iy="Conc", boolsave=FALSE)
plot(x)
}

}
\seealso{
\code{\link{set.plotoptions}}
}
\keyword{plot}
