% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-projection.test.R
\name{projection.test}
\alias{projection.test}
\title{Projection test}
\usage{
projection.test(dat, Wlist, base, alpha = 0.05)
}
\arguments{
\item{dat}{a dataframe or matrix, of which the first three columns are survival
time, event status indicator  and group label. The status indicator, normally
0=alive, 1=dead/event. Other choices are TRUE/FALSE (TRUE=death) or 1/2 (2=death).
The group label can be either numeric values like 0=control, 1=treatment or text
like C=control, T=treatment.}

\item{Wlist}{a list object with components of weight functions}

\item{base}{a text must be one of c("\code{KM}","\code{Combined}","\code{N}"), Default: c("KM")}

\item{alpha}{a number indicating type I error rate, Default: 0.05}
}
\value{
a list of components including
\item{chisq}{a numeric value indicating the chi-square statistic}
\item{df.chis}{a numeric value indicating the degree freedom of the test}
\item{pvalue}{a numeric value giving the p-value of the test }
\item{details}{a data frame consisting of statistics from multiple
weight functions and the variance-covariance matrix}
}
\description{
Perform projection test as proposed by Brendel (2014)
}
\details{
The base functions are the same as those described in function
\code{MaxLRtest}. The method detail can be found in Brendel (2014)
paper. The main idea is to map the multiple weighted logrank statistics
into a chi-square distribution. The degree freedom of the chi-square
is the rank of the generalized inverse of covariance matrix. Only two-sided
test is supported in the current function.
}
\examples{
# load and prepare data
data(lung)
tmpd <- with(lung, data.frame(time=SurvTime,stat=1-censor,grp=Treatment))
# two weight functions are defined.
# one is constant weight; the other emphasize diverging hazards
timef1 <- function(x){1}
timef2 <- function(x){(x)}
test1 <- projection.test(tmpd,list(timef1,timef2),base="KM")
test1$chisq; test1$pvalue; test1$df.chisq
}
\references{
Brendel, M., Janssen, A., Mayer, C. D., & Pauly, M. (2014). Weighted logrank
permutation tests for randomly right censored life science
data. Scandinavian Journal of Statistics, 41(3), 742-761.
}
\seealso{
\code{\link{MaxLRtest}}
}
