% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhenKplot.R
\encoding{UTF-8}
\name{PhenKplot}
\alias{PhenKplot}
\title{PhenKplot}
\usage{
PhenKplot(x, dates, h, nGS, xlab, ylab, rge)
}
\arguments{
\item{x}{Numeric vector with greenness values}

\item{dates}{Vector with dates at which the greenness values were recorded}

\item{h}{Numeric. Indicates the geographic hemisphere to define the starting date of the growing season. h=1 if the vegetation is in the Northern Hemisphere (season starting at January 1st), h=2 if it is in the Southern Hemisphere (season starting at July 1st)}

\item{nGS}{Numeric. Number of greenness values within a single growing season. For example, nGS=23 for MODIS    Vegetation Index 16-days composites}

\item{xlab}{Character vector (or expression) giving plot title in x axis label}

\item{ylab}{Caracter vector (or expression) giving plot title in y axis label}

\item{rge}{A vector containing minimum and maximum values of the response variable used in the analysis. We suggest the use of theoretically based limits. For example in the case of MODIS NDVI or EVI, it ranges from 0 to 10,000, so rge =c(0,10000)}
}
\description{
Plot the most probable vegetation greenness values.
}
\details{
It is the graphical version of the Phen function. It calculates and plot a likelihood map of the vegetation-greenness – time space using a numeric vector of vegetation canopy greenness values (e.g. Leaf Area Index (LAI) or greenness proxies values such as the Normalized Difference Vegetation Index (NDVI) or Enhanced Vegetation Index (EVI). Also a vector with dates for the greenness values is required. This function calculates the confidence areas on a per year basis. Functions for confidence intervals on per day basis are under development. This function is partially based on the ci2d function on package gplots.
}
\examples{
\donttest{
library(lubridate)

## Testing North Hemisphere data. Raster data from Slovenia (EVI index), h=1 ##

# Load data
sl.path<-system.file("extdata/HN_slovenia",package="npphen")
sl_rasters<-list.files(path=sl.path, pattern=glob2rx("slovenia*.tif"), full.names=TRUE)
Slovenia_rasters<-stack(sl_rasters)
sl_dates<-read.csv(system.file("extdata/date_tables/Slovenia_dates.csv", package="npphen"))
Slovenia_dates <- as.Date(sl_dates$date, format='\%d/\%m/\%Y')

# Generate a Raster time series using a raster stack and a date database from Slovenia
# Obtain data from a particular pixel generating a time series
sl_pixel<-cellFromXY(Slovenia_rasters,c(474368,5096979))
sl_pixelts<-as.numeric(Slovenia_rasters[sl_pixel])
plot(Slovenia_dates,sl_pixelts, type='l')

# Phenology for the given pixel
PhenKplot(x=sl_pixelts,dates=Slovenia_dates,h=1,nGS=23, xlab="DOY",
ylab="EVI", rge=c(0,10000))


## Testing South Hemisphere data. Raster data from Chile (EVI index), h=2 ##

# Load data
ay.path<-system.file("extdata/HS_aysen",package="npphen")
ayrasters<-list.files(path=ay.path, pattern=glob2rx("aysen*.tif"), full.names=TRUE)
Aysen_rasters<-stack(ayrasters)
ay_dates<-read.csv(system.file("extdata/date_tables/Aysen_dates.csv", package="npphen"))
Aysen_dates <- as.Date(ay_dates$date, format='\%d/\%m/\%Y')

# Generate a Raster time series using a raster stack and a date database from Aysen
# Obtain data from a particular pixel generating a time series
ay_pixel<-cellFromXY(Aysen_rasters,c(228373,4806975))
ay_pixelts<-as.numeric(Aysen_rasters[ay_pixel])
plot(Aysen_dates,ay_pixelts, type = 'l')

# Phenology for the given pixel
PhenKplot(x=ay_pixelts,dates=Aysen_dates,h=2,nGS=23, xlab="DOY",
ylab="EVI", rge=c(0,10000))
}
}
\seealso{
\code{\link{Phen}}
}
