% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAge.R
\name{calcAge}
\alias{calcAge}
\title{Calculate animal ages.}
\usage{
calcAge(birth, exit)
}
\arguments{
\item{birth}{Date vector of birth dates}

\item{exit}{Date vector of exit dates.}
}
\value{
A numeric vector (\code{NA} allowed) indicating age in decimal years
from "birth" to "exit" or the current date if "exit" is NA.
}
\description{
Part of Pedigree Curation
}
\details{
Given vectors of birth and exit dates, calculate an individuals age. If no
exit date is provided, the calculation is based on the current date.
}
\examples{
\donttest{
library(nprcgenekeepr)
qcPed <- nprcgenekeepr::qcPed
originalAge <- qcPed$age ## ages calculated at time of data collection
currentAge <- calcAge(qcPed$birth, qcPed$exit) ## assumes no changes in
                                               ## colony
}

}
