% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPyramidAgeDist.R
\name{getPyramidAgeDist}
\alias{getPyramidAgeDist}
\title{Get the age distribution for the pedigree}
\usage{
getPyramidAgeDist(ped = NULL)
}
\arguments{
\item{ped}{dataframe with pedigree}
}
\value{
A pedigree with \code{status} column added, which describes the
animal as \code{ALIVE} or \code{DECEASED} and a \code{age} column added,
which has the animal's age in years or \code{NA} if it cannot be calculated.
The \code{exit} column values have been remapped to valid dates or \code{NA}.
}
\description{
Forms a dataframe with columns \code{id}, \code{birth}, \code{sex},
and {age} for those animals with a status of \code{Alive} in the pedigree.
}
\details{
The lubridate package is used here because of the way the modern Gregorian
calendar is constructed, there is no straightforward arithmetic method
that produces a person’s age, stated according to common usage — common
usage meaning that a person’s age should always be an integer that
increases exactly on a birthday.
}
\examples{
\donttest{
library(nprcgenekeepr)
ped <- getPyramidAgeDist()
}

}
