% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Compare two NP classification methods at different thresholds.}
\usage{
compare(roc1, roc2, plot = TRUE, col1 = "black", col2 = "red")
}
\arguments{
\item{roc1}{the first nproc object.}

\item{roc2}{the second nproc object.}

\item{plot}{whether to generate the two NP-ROC plots and mark the area of significant difference. Default = 'TRUE'.}

\item{col1}{the color of the region where roc1 is significantly better than roc2. Default = 'black'.}

\item{col2}{the color of the region where roc2 is significantly better than roc1. Default = 'red'.}
}
\value{
A list with the following items.
\item{alpha1}{the alpha values where roc1 is significantly better than roc2. }
\item{alpha2}{the alpha values where roc2 is significantly better than roc1. }
\item{alpha3}{the alpha values where roc1 and roc2 are not significantly different.}
\item{confidence}{represents the confidence level.}
}
\description{
\code{compare} compares NP classification methods and provide the regions where one method is better than the other. The two NP-ROC curves are both required to have band = TRUE.
}
\examples{
n = 1000
set.seed(1)
x1 = c(rnorm(n), rnorm(n) + 1)
x2 = c(rnorm(n), rnorm(n)*sqrt(6) + 1)
y = c(rep(0,n), rep(1,n))
fit1 = nproc(x1, y, band = TRUE, method = 'lda')
fit2 = nproc(x2, y, band = TRUE, method = 'lda')
v = compare(fit1, fit2)
legend('topleft',legend=c('x1','x2'),col=1:2,lty=c(1,1))

}
\references{
Xin Tong, Yang Feng, and Jingyi Jessica Li (2016), Neyman-Pearson (NP) classification algorithms and NP receiver operating characteristic (NP-ROC) curves, manuscript, http://arxiv.org/abs/1608.03109.
}
\seealso{
\code{\link{npc}}, \code{\link{nproc}}, \code{\link{predict.npc}} and \code{\link{plot.nproc}}
}

