% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_rigid_regression.R
\name{simulate_rigid_regression}
\alias{simulate_rigid_regression}
\title{Simulates a Rigid 3D Spherical Regression.}
\usage{
simulate_rigid_regression(
  explanatory_points,
  rotation_matrix,
  local_error_sampler
)
}
\arguments{
\item{explanatory_points}{An \emph{m}-by-3 matrix whose rows contain
the Cartesian coordinates of the points at which the regression
will be simulated.}

\item{rotation_matrix}{A 3-by-3 rotation matrix.}

\item{local_error_sampler}{A function that returns a 3-length numeric vector
representing a sampled error term local to an explanatory point,
given its Cartesian coordinates.}
}
\value{
An \emph{m}-by-\emph{3} matrix whose rows contain
the Cartesian coordinates of the response points corresponding
to the explanatory points.
}
\description{
Returns the response points corresponding to the specified explanatory
points, given a rigid rotation model
and an error term sampler.
}
\details{
Let \eqn{E} be
the \emph{m}-by-3 matrix of explanatory points.
This function will return
an \emph{m}-by-\emph{3} matrix whose \eqn{i}-th row is obtained by
transposition of the following expression:

\deqn{exp(\Phi(\epsilon(x))) R x}

where \eqn{x} is the transpose of the \eqn{i}-th row of
\eqn{E} and \eqn{R} is \code{rotation_matrix}.
Term \eqn{\epsilon(x)} is obtained by
evaluating at \eqn{x} function \code{local_error_sampler}, while
matrix \eqn{\Phi(c)}, for a 3-length numeric vector \eqn{c}, is
the skew symmetric matrix having its independent components
represented by the entries of \eqn{c} (for a thorough discussion,
see function
\code{\link{get_skew_symmetric_matrix}}).

Function \code{local_error_sampler}
must be prototyped as having one argument, \code{point},
representing the Cartesian coordinates of a point on a 3D sphere,
and returning a non \code{NULL} numerical object having length
equal to \code{3}.
}
\examples{
library(nprotreg)

# Define a matrix of explanatory points.

explanatory_points <- rbind(
  cbind(.5, 0, .8660254),
  cbind(-.5, 0, .8660254),
  cbind(1, 0, 0),
  cbind(0, 1, 0),
  cbind(-1, 0, 0),
  cbind(0, -1, 0),
  cbind(.5, 0, -.8660254),
  cbind(-.5, 0, -.8660254)
)

# Define a rotation matrix.

rotation_matrix <- rbind(
    cbind(-0.69492055764131177575, 0.71352099052778772403, 0.08929285886191218324),
    cbind(-0.19200697279199935297, -0.30378504433947051133, 0.93319235382364695841),
    cbind(0.69297816774177023458, 0.63134969938371787723, 0.34810747783026463331)
)

# Define a local error sampler.

local_error_sampler <- function(point) {
  rnorm(3)
}

# Get the corresponding 8-by-3 matrix of response points.
# Rows corresponds to explanatory points,
# columns to Cartesian coordinates.

response_points <- simulate_rigid_regression(explanatory_points,
                                             rotation_matrix,
                                             local_error_sampler)

# Get the response point corresponding to the second
# explanatory point.

cat("Response point corresponding to the second explanatory point: \n")
cat(response_points[2, ], "\n")
}
\seealso{
Other Regression functions: 
\code{\link{cross_validate_concentration}()},
\code{\link{fit_regression}()},
\code{\link{get_equally_spaced_points}()},
\code{\link{get_skew_symmetric_matrix}()},
\code{\link{simulate_regression}()},
\code{\link{weight_explanatory_points}()}
}
\concept{Regression functions}
