\docType{package}
\name{npsp-package}
\alias{npsp}
\alias{npsp-package}
\title{npsp: Nonparametric spatial (geo)statistics}
\description{
  This package implements nonparametric methods which may
  be useful in geostatistical practice.
}
\section{Main functions}{
  \code{\link{locpol}}, \code{\link{np.den}} and
  \code{\link{np.svar}} use local polynomial kernel methods
  to compute nonparametric estimates of a multidimensional
  regression function, a probability density function or a
  semivariogram (or their first derivatives), respectively.
  Estimates of these functions can be constructed for any
  dimension (the amount of available memory is the only
  limitation). To speed up computations, linear binning is
  used to discretize the data. A full bandwidth matrix and
  a multiplicative triweight kernel is used to compute the
  weights. Main calculations are performed in FORTRAN using
  the LAPACK library.

  \code{\link{fitsvar.sb.iso}} fits a `nonparametric'
  isotropic Shapiro-Botha variogram model by WLS.
  Currently, only isotropic semivariogram estimation is
  supported.

  Among the other functions intended for direct access by
  the user, the following could be emphasized:
  \code{\link{binning}}, \code{\link{bin.den}},
  \code{\link{svar.bin}}, \code{\link{h.cv}} and
  \code{\link{interp}}. There are also some functions which
  can be used to interact with other packages. For
  instance, \code{\link{as.variogram}} (\pkg{geoR}) or
  \code{\link{as.vgm}} (\pkg{gstat}).

  Kriging is not yet implemented in this package. Users are
  encouraged to use \code{\link[gstat]{krige}} (or
  \code{\link[gstat]{krige.cv}}) utilities in \pkg{gstat}
  package together with \code{\link{as.vgm}}.
}

\section{Acknowledgments}{
  Important suggestions and contributions to some
  techniques included here were made by Tomas
  Cotos-Ya\~{n}ez (Dep. Statistics, University of Vigo,
  Spain).
}
\author{
  Ruben Fernandez-Casal (Dep. Mathematics, University of A
  Coru\~{n}a, Spain). Please send comments, error reports
  or suggestions to \url{rubenfcasal@gmail.com}.
}
\references{
  Fernandez Casal R., Gonzalez Manteiga W. and Febrero
  Bande M. (2003) Flexible Spatio-Temporal Stationary
  Variogram Models, \emph{Statistics and Computing},
  \bold{13}, 127-136.

  Rupert D. and Wand M.P. (1994) Multivariate locally
  weighted least squares regression.  \emph{The Annals of
  Statistics}, \bold{22}, 1346-1370.

  Shapiro A. and Botha J.D. (1991) Variogram fitting with a
  general class of conditionally non-negative definite
  functions. \emph{Computational Statistics and Data
  Analysis}, \bold{11}, 87-96.

  Wand M.P. (1994) Fast Computation of Multivariate Kernel
  Estimators.  \emph{Journal of Computational and Graphical
  Statistics}, \bold{3}, 433-445.

  Wand M.P. and Jones M.C. (1995) \emph{Kernel Smoothing}.
  Chapman and Hall, London.
}
\keyword{nonparametric}
\keyword{smooth}

