% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.grid.R
\name{data.grid}
\alias{data.grid}
\alias{data.grid-class}
\title{Gridded data (S3 class "data.grid")}
\usage{
data.grid(
  ...,
  grid = NULL,
  window = NULL,
  mask = NULL,
  set.NA = FALSE,
  warn = FALSE
)
}
\arguments{
\item{...}{vectors or arrays of data with length equal to \code{prod(grid$n)}.}

\item{grid}{a \code{\link{grid.par}}-\code{\link{class}} object (optional).}

\item{window}{spatial window (values outside this window will be masked), currently an sp-object of class 
extending \code{\link[sp:SpatialPolygons-class]{SpatialPolygons}}.}

\item{mask}{logical; vector (or array) indicating the selected values (not masked).}

\item{set.NA}{logical; If \code{TRUE}, the values corresponding
to masked cells are set to \code{NA}.}

\item{warn}{logical; If \code{TRUE} a warning message is generated when original data is masked.}
}
\value{
Returns an object of \code{\link{class}} \code{data.grid}, a list with 
the arguments as components.
}
\description{
Defines data on a full regular (spatial) grid. 
Constructor function of the \code{data.grid}-\code{\link{class}}.
}
\details{
If parameter \code{grid.par} is not specified it is set from first argument.

S3 "version" of the \code{\link[sp]{SpatialGridDataFrame}}-\code{\link{class}} 
of the \pkg{sp} package.
}
\examples{
# Grid parameters
grid <- grid.par(n = c(15,15), min = c(x = -1, y = -1), max = c(1, 1))
coordinates <- coords(grid)
plot(coordinates)
coordvs <- coordvalues(grid)
abline(v = coordvs[[1]], lty = 3)
abline(h = coordvs[[2]], lty = 3)
# Gridded data
y <- apply(coordinates, 1, function(x) x[1]^2 - x[2]^2 )
datgrid <- data.grid(y = y, grid = grid)
spersp(datgrid, main = 'f(x,y) = x^2 - y^2')
dim(datgrid)
all.equal(coordinates, coords(datgrid))
}
\seealso{
\code{\link{as.data.grid}}, \code{\link{grid.par}}, \code{\link{mask}}, 
\code{\link{binning}}, \code{\link{locpol}}.
}
