% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_loss.R
\name{dloss}
\alias{dloss}
\alias{ploss}
\alias{hloss}
\alias{qloss}
\alias{rloss}
\title{Loss to follow-up}
\usage{
dloss(x, arm)

ploss(q, arm, lower.tail = T)

hloss(x, arm)

qloss(p, arm, lower.tail = T)

rloss(n = 1, arm)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{arm}{object of class 'arm'.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P(X \le x)};
otherwise, \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dloss} gives the density, \code{ploss} gives the distribution
  function, \code{hloss} gives the hazard function, \code{qloss} gives the
  quantile function, and \code{rloss} generates random deviates.
}
\description{
Density, distribution function, hazard function, quantile function,
and random generation for the loss to follow-up distribution.
}
\seealso{
\code{\link{create_arm}} and \code{\link{create_arm_lachin}}
  for creating an object of class 'arm'.
}
