% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-involvement-survey.R
\docType{data}
\name{involvement_survey_str2s_rscales}
\alias{involvement_survey_str2s_rscales}
\title{Replicate-specific scale factors for the parent involvement survey stratified, two-stage sample}
\format{
A list with elements \code{'bootstrap'} and \code{'JKn'},
each a numeric vector of replicate-specific scale factors to supply to the
\code{svrepdesign} function from the 'survey' package.
}
\usage{
involvement_survey_str2s_rscales
}
\description{
Replicate-specific scale factors for the parent involvement survey stratified, two-stage sample
}
\examples{
library(survey)
data('involvement_survey_str2s', package = 'nrba')

# Using jackknife replicates
involvement_survey <- svrepdesign(
  data = involvement_survey_str2s,
  weights = ~ BASE_WEIGHT,
  repweights = "JKn_Rep_Wt",
  rscales = involvement_survey_str2s_rscales$JKn,
  type = "JKn",
)
# Using bootstrap replicates
involvement_survey <- svrepdesign(
  data = involvement_survey_str2s,
  weights = ~ BASE_WEIGHT,
  repweights = "Boot_Rep_Wt",
  rscales = involvement_survey_str2s_rscales$bootstrap,
  type = "bootstrap",
)
}
\keyword{datasets}
