% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-preopen.R
\name{preopen_nifty}
\alias{preopen_nifty}
\alias{nse_preopen_nifty}
\alias{nse_preopen_nifty_bank}
\title{Pre Open market data}
\usage{
nse_preopen_nifty(clean_names = TRUE)

nse_preopen_nifty_bank(clean_names = TRUE)
}
\arguments{
\item{clean_names}{Logical; if \code{TRUE}, makes the column names
descriptive and uses snake_case.}
}
\value{
A tibble with the following columns:

\item{symbol}{NSE ticker.}
\item{series}{Equity (EQ)}
\item{corp_action_date}{Corporate action date.}
\item{corp_action}{Corporate Action}
\item{price}{Price}
\item{change}{Change in price}
\item{percent_change}{Percentage change in price.}
\item{prev_close}{Previous close.}
\item{quantity}{Quantity}
\item{value}{Value (in lakhs),}
\item{mkt_cap}{Free float market capitalization (in crores).}
\item{year_high}{Normal market 52 week high.}
\item{year_low}{Normal market 52 week low.}
}
\description{
Fetch data of pre open session of Nifty & Nifty Bank.
}
\examples{
\dontrun{
# nifty
nse_preopen_nifty()

# retain original column names as returned by NSE
nse_preopen_nifty(clean_names = FALSE)

# nifty bank
nse_preopen_nifty_bank()

# retain original column names as returned by NSE
nse_preopen_nifty_bank(clean_names = FALSE)
}

}
