% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhavs.R
\name{bhavs}
\alias{bhavs}
\title{Equity Bhavcopy through RSelenium}
\source{
<https://www1.nseindia.com/products/content/equities/equities/archieve_eq.htm>
}
\usage{
bhavs(x, n = 0)
}
\arguments{
\item{x}{numeric date format (ddmmyyyy)}

\item{n}{time interval to delay in seconds. DEFAULT = 0}
}
\value{
Download Equity Bhavcopy zip file of the given date.
}
\description{
Equity Bhavcopy through RSelenium
}
\details{
Gets zip Bhavcopy from NSE for the given date.
}
\note{
The date should be strictly numerical of format 'ddmmyyyy' and mentioned in quotation mark.
}
\examples{
\dontrun{ # Start a selenium server and browser
# For Google Chrome (Update Chrome to latest version)
driver = rsDriver(browser = c("chrome"), port = 3163L, chromever = "91.0.4472.101")
remDr = driver$client

# For Firefox
driver = rsDriver(browser = c("firefox"), port = 3799L)

# Download Equity Bhavcopy zip file
bhavs("03012000", 3)

# Close the Browser
remDr$close()
}
}
\seealso{
\code{\link[nser]{bhavpr}}\code{\link[nser]{bhavtoday}}\code{\link[nser]{bhav}}\code{\link[nser]{fobhav}}
}
\author{
Nandan L. Patil \email{tryanother609@gmail.com}
}
