% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhavtoday.R
\name{bhavtoday}
\alias{bhavtoday}
\title{Get Bhavcopy for the present day}
\source{
<https://www.nseindia.com/all-reports>, <https://www.bseindia.com/markets/marketinfo/BhavCopy.aspx>
}
\usage{
bhavtoday(se = "NSE")
}
\arguments{
\item{se}{Stock Exchange either 'NSE' or 'BSE'. Default is 'NSE'.}
}
\value{
Todays's Bhavcopy.
}
\description{
Get Bhavcopy for the present day
}
\details{
Gets todays bhavcopy from NSE. The function tries to get the bhavcopy from two sources Old and New website of NSE.
}
\note{
The date should be strictly numerical and mentioned in quotation mark.The present days Bhavcopy would usually available in the evening
}
\examples{
\dontrun{

#Todays NSE Equity Bhavcopy, the data would be available usually after 6.30 PM.
library(nser)
report = bhavtoday()

#Todays BSE Equity Bhavcopy
report = bhavtoday('BSE')
}
}
\seealso{
\code{\link[nser]{bhavpr}}\code{\link[nser]{bhav}}
}
\author{
Nandan L. Patil \email{tryanother609@gmail.com}
}
