% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R, R/force.R
\name{quo}
\alias{quo}
\alias{quotation}
\alias{quo_}
\alias{env}
\alias{env<-}
\alias{expr}
\alias{expr.quotation}
\alias{expr<-}
\alias{is.quotation}
\alias{is.quo}
\alias{as.quo}
\alias{forced_quo}
\alias{forced_quo_}
\title{Quotation objects.}
\usage{
quo(expr, env = arg_env_(quote(expr), environment()), force = FALSE)

quo_(expr, env, force = FALSE)

env(q)

env(q) <- value

expr(q)

\method{expr}{quotation}(q)

expr(q) <- value

is.quotation(x)

is.quo(x)

as.quo(x)

forced_quo(x)

forced_quo_(val)
}
\arguments{
\item{expr}{An expression. For \code{quo} this is taken literally and
not evaluated. For \code{quo_} this is evaluated normally.}

\item{env}{An \link{environment}.}

\item{force}{Whether to evaluate the expression and create a
\link{forced} quotation.}

\item{q}{A quotation object.}

\item{value}{An updated value.}

\item{x}{Any object.}

\item{val}{A value.}
}
\value{
\code{quo_} and \code{quo} return an object of class "quotation".

\code{as.quo} returns a quotation.
}
\description{
\code{quo(expr, env)} captures \code{expr} without evaluating, and returns a
qutation object. A quotation has two parts: an
expression \code{expr(q)} with an environment \code{env(q)}.

\code{quo_(expr, env)} is the normally evaluating version. It
constructs a quotation given an expression and environment.

\code{as.quo(x)} converts an object into a quotation. Closures,
formulas, and single-element \link{dots} can be converted this way.

\code{forced_quo(x)} captures the expression in its argument, then
forces it, returning a quotation with the expression and value.

\code{forced_quo_(val)} makes a \link{forced} quotation given a value.
Specifically it constructs a \link{quotation} with the same object in
both the \code{expr} and \code{value} slots, except if is a
\link[=is.language]{language} object in which case the \code{expr} slot is wrapped
in \code{quote()}.
}
\details{
(Like in writing, an 'expression' may simply be a set of words, but
a 'quotation' comes bundled with a citation, to reference a context
in which it was said.)

A quo is parallel to a 'promise' which is the data structure R uses
to hold lazily evaluated arguments. A quo is different from a
promise because it is an immutable data object.

As a data object, a quo does not automatically evaluate like a
promise, but can be evaluated explicitly with the methods \link{value}
or \link{force_}.  A quo is immutable, so it does not mutate into a
"forced" state if you choose to evaluate it; instead \code{force_(q)}
returns a new object in the forced state.

A function can capture its arguments as quotations using \code{\link{arg}}.

A \link{dots} object is a list of quotations.
}
