% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsLaplace.R
\name{Neutrosophic Laplace}
\alias{Neutrosophic Laplace}
\alias{dnsLaplace}
\alias{pnsLaplace}
\alias{qnsLaplace}
\alias{rnsLaplace}
\title{Neutrosophic Laplace (Double Exponential) Distribution}
\usage{
dnsLaplace(x, location, scale)

pnsLaplace(q, location, scale, lower.tail = TRUE)

qnsLaplace(p, location, scale)

rnsLaplace(n, location, scale)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{location}{the location parameter, which is the mean.}

\item{scale}{the scale parameter, Must consist of positive values.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \leq x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{dnsLaplace} gives the density function

\code{pnsLaplace} gives the distribution function

\code{qnsLaplace} gives the quantile function

\code{rnsLaplace} generates random values from the neutrosophic Laplace distribution.
}
\description{
Density, distribution function, quantile function, and random
generation for the neutrosophic Laplace (Double Exponential)
distribution with parameters \code{location} =  \eqn{\theta_N} and
\code{scale} = \eqn{\beta_N}.
}
\details{
The neutrosophic Laplace distribution with parameters \eqn{\theta_N}
and \eqn{\beta_N} has density
\deqn{f_N(x) = \frac{1}{2\beta_N} \exp\left\{-\frac{|x-\theta_N|}{\beta_N}\right\}}
for \eqn{-\infty < x < \infty}, \eqn{\theta_N \in (\theta_L, \theta_U)}, the location parameter,
\eqn{\beta_N \in (\beta_L, \beta_U)}, the scale parameter which be a positive interval.
}
\examples{
dnsLaplace(x = c(4, 4.1), location = c(0.23, 0.24), scale = c(1, 2))
dnsLaplace(4, location = c(0.23, 0.24), scale = c(1, 2))


# The cumulative distribution function for the neutrosophic observation (4,4.1)
pnsLaplace(q = c(4, 4.1), location = c(0.23, 0.24), scale = c(1, 2))
# The first percentile
qnsLaplace(p = 0.1, location = 0.24, scale = 2)

# The quantiles
qnsLaplace(p = c(0.25, 0.5, 0.75), location = c(0.23, 0.24), scale = c(1, 2))

# Simulate 10 numbers
rnsLaplace(n = 10, location = c(0.23, 0.24), scale = c(1, 2))
}
\references{
Rahul, T., Malik, S. C., Raj, M. (2023). Neutrosophic Laplace Distribution
with Application in Financial Data Analysis, \emph{Neutrosophic Sets and Systems},
57(1), 224-233.
}
