\name{null_lm}
\alias{null_lm}
\title{Generate null data with null residuals from a model.}
\usage{null_lm(f, method="rotate")}

\description{
  Generate null data with null residuals from a model.
}

\details{
  Null hypothesis: variable is linear combination of
  predictors
}
\value{a function that given \code{data} generates a null data set.  
For use with \code{\link{lineup}} or \code{\link{rorschach}}}
\arguments{
  \item{f}{model specification formula, as defined by \code{\link{lm}}}
  \item{method}{method for generating null residuals.  Built in methods
"rotate", "pboot" and "boot" are defined by \code{\link{resid_rotate}},
\code{\link{resid_pboot}} and \code{\link{resid_boot}} respectively}
}
\examples{library(ggplot2)

x <- lm(tip ~ total_bill, data = tips)
tips.reg <- data.frame(tips, .resid = residuals(x), .fitted = fitted(x))
qplot(total_bill, .resid, data = tips.reg) \%+\% 
lineup(null_lm(tip ~ total_bill, method = "rotate"), tips.reg) + 
facet_wrap(~ .sample)}
