% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_month.R
\name{f_month}
\alias{f_month}
\alias{f_month.default}
\alias{f_month.numeric}
\alias{f_month.Date}
\alias{f_month.POSIXlt}
\title{Format Months to One Letter Abbreviation}
\usage{
f_month(x, ...)

\method{f_month}{default}(x, ...)

\method{f_month}{numeric}(x, ...)

\method{f_month}{Date}(x, ...)

\method{f_month}{POSIXlt}(x, ...)
}
\arguments{
\item{x}{A vector of month names, integers 1-12, or dates.}

\item{\ldots}{ignored.}
}
\value{
Returns a single letter month abbreviation atomic vector.
}
\description{
Format long month name, integer, or date formats to a single capital letter.
Useful for plot scales as a way to save space.
}
\examples{
f_month(month.name)

f_month(1:12)

dates <- seq(as.Date("2000/1/1"), by = "month", length.out = 12)
f_month(dates)
\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load(tidyverse)

set.seed(10)
dat <- data_frame(
    month = sample(month.name, 1000, TRUE),
    area =  sample(LETTERS[1:5], 1000, TRUE)
) \%>\%
    count(month, area) \%>\%
    ungroup() \%>\%
    mutate(month = factor(month, levels = month.name))

## without date formatting
ggplot(dat, aes(month, n)) +
    geom_bar(stat = 'identity') +
    facet_wrap(~ area)

## with date formatting
ggplot(dat, aes(month, n)) +
    geom_bar(stat = 'identity') +
    facet_wrap(~ area) +
    scale_x_discrete(labels = f_month)
}
}
