% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_denom.R
\name{f_denom}
\alias{f_denom}
\alias{ff_denom}
\alias{f_bills}
\alias{ff_bills}
\alias{f_mills}
\alias{ff_mills}
\alias{f_thous}
\alias{ff_thous}
\title{Abbreviate Numbers}
\usage{
f_denom(x, relative = 0, prefix = "", pad.char = ifelse(prefix == "",
  NA, " "), less.than.replace = FALSE, mix.denom = FALSE, ...)

ff_denom(...)

f_bills(x, relative = 0, digits = -9, prefix = "",
  pad.char = ifelse(prefix == "", NA, " "), less.than.replace = FALSE,
  ...)

ff_bills(...)

f_mills(x, relative = 0, digits = -6, prefix = "",
  pad.char = ifelse(prefix == "", NA, " "), less.than.replace = FALSE,
  ...)

ff_mills(...)

f_thous(x, relative = 0, digits = -3, prefix = "",
  pad.char = ifelse(prefix == "", NA, " "), less.than.replace = FALSE,
  ...)

ff_thous(...)
}
\arguments{
\item{x}{A vector of large numbers.}

\item{relative}{A factor relative to the current \code{digits} being rounded.
For example \code{relative = -1} moves one to the left while
\code{relative = 1} moves one to the right.}

\item{prefix}{A string to append to the front of elements.}

\item{pad.char}{A character to use for leading padding if lengths of output
are unequal.  Use \code{NA} to forgo padding.}

\item{less.than.replace}{logical.  If \code{TRUE} values lower than lowest
place value will be replaced with a less than sign followed by the
\code{integer} representation of the place value.  For example, if \code{"$0K"}
then replacement will be \code{"<1K"}.}

\item{mix.denom}{logical.  If \code{TRUE} then denominations can be mixed.
Typically this is not a good idea for the sake of comparison.  It is most
useful when there is a total row which is a sum of the column and this value's
denomination exceeds the denomination of the rest of the column.}

\item{digits}{The number of digits to round to.  Actual \code{digits}
calculated as \code{digits} +  \code{relative}.}

\item{\ldots}{ignored.}
}
\value{
Returns an abbreviated vector of numbers.
}
\description{
Use the denomination abbreviations K (thousands), M (millions), and
B (billions) with abbreviated numbers.\cr\code{f_denom} - Auto-detect the
maximum denomination and attempt to use it (if max(x) is < 1K then x is
returned).

\code{f_bills} - Force the abbreviation to the billions
denomination (B).

\code{f_mills} - Force the abbreviation to the millions
denomination (B).

\code{f_thous} - Force the abbreviation to the thousands
denomination (B).
}
\examples{
f_denom(c(12345, 12563, 191919), prefix = '$')
f_denom(c(12345, 12563, 191919), prefix = '$', pad.char = '')
f_denom(c(1234365, 122123563, 12913919), prefix = '$')
f_denom(c(12343676215, 122126763563, 1291673919), prefix = '$')
f_denom(c(NA, 2, 12343676215, 122126763563, 1291673919), prefix = '$')
f_denom(c(NA, 2, 123436, 122126763, 1291673919), prefix = '$', mix.denom = TRUE)
f_denom(c(NA, 2, 12343676215, 122126763563, 1291673919), prefix = '$', pad.char = '')
f_denom(c(NA, 2, 12343676215, 122126763563, 1291673919), relative = 1, prefix = '$')
f_denom(c(NA, 2, 12343676215, 122126763563, 1291673919), relative = 9, prefix = '$')
f_denom(c(NA, 2, 12343676215, 122126763563, 1291673919), less.than.replace = TRUE)

f_thous(1234)
f_thous(12345)
f_thous(123456)
f_mills(1234567)
f_mills(12345678)
f_mills(123456789)
f_bills(1234567891)
f_bills(12345678912)
f_bills(123456789123)

f_bills(123456789123, -1) # round to tens
f_bills(123456789123, -2) # round to hundreds
f_bills(123456789123, +1) # round to tenths
f_bills(123456789123, +2) # round to hundreths

x <- c(3886902.8696, 4044584.0424, 6591893.2104, 591893.2104, -3454678)
f_mills(x)
f_mills(x, 1)
f_mills(x, 1, prefix = '$')
f_mills(x, 1, prefix = '$', pad.char = '0')

\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load(tidyverse, magrittr)

f_bills(123456789123, -2) \%>\%
    f_prefix("$")


data_frame(
    revenue = rnorm(100, 500000, 50000),
    deals = sample(20:50, 100, TRUE)
) \%>\%
    mutate(
        dollar = f_dollar(revenue, digits = -3),
        thous = f_thous(revenue),
        thous_dollars = f_thous(revenue, prefix = '$')
    ) \%T>\%
    print() \%>\%
    ggplot(aes(deals, revenue)) +
        geom_point() +
        geom_smooth() +
        scale_y_continuous(label = ff_thous(prefix = '$') )

data_frame(
    revenue = rnorm(10000, 500000, 50000),
    date = sample(seq(as.Date('1999/01/01'), as.Date('2000/01/01'), by="day"), 10000, TRUE),
    site = sample(paste("Site", 1:5), 10000, TRUE)
) \%>\%
    mutate(
        dollar = f_dollar(revenue, digits = -3),
        thous = f_thous(revenue),
        thous_dollars = f_thous(revenue, prefix = '$'),
        abb_month = f_month(date),
        abb_week = factor(f_weekday(date, distinct = TRUE),
        levels = c('Su', 'M', 'T', 'W', 'Th', 'F', 'S'))
    ) \%T>\%
    print() \%>\%
    ggplot(aes(abb_week, revenue)) +
        geom_jitter(width = .2, height = 0, alpha = .2) +
        scale_y_continuous(label = ff_thous(prefix = '$'))+
        facet_wrap(~site)

set.seed(10)
data_frame(
    w = paste(constant_months, rep(2016:2017, each = 12))[1:20] ,
    x = rnorm(20, 200000, 75000)
) \%>\%
    {
        a <- .
        rbind(
            a,
            a \%>\%
                mutate(w = 'Total') \%>\%
                group_by(w) \%>\%
                summarize(x = sum(x))
        )
    } \%>\%
    mutate(
        y = f_denom(x, prefix = '$'),
        z = f_denom(x, mix.denom = TRUE, prefix = '$')
    )  \%>\%
    data.frame(stringsAsFactors = FALSE, check.names = FALSE) \%>\%
    pander::pander(split.tables = Inf, justify = alignment(.))

## Scale with mixed units
library(tidyverse)
library(numform)

dat <- data_frame(
    Value = c(111, 2345, 34567, 456789, 1000001, 1000000001),
    Time = 1:6
)

## Uniform units
ggplot(dat, aes(Time, Value)) +
    geom_line() +
    scale_y_continuous(labels = ff_denom( prefix = '$'))

## Mixed units
ggplot(dat, aes(Time, Value)) +
    geom_line() +
    scale_y_continuous(labels = ff_denom(mix.denom = TRUE, prefix = '$', pad.char = ''))
}
}
