% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight_cells.R
\name{highlight_cells}
\alias{highlight_cells}
\title{Highlight Cells}
\usage{
highlight_cells(data, rows, columns = seq_len(ncol(data)),
  left = "<b>", right = gsub("(<)([^> ]+)([^>]*>)", "\\\\1/\\\\2>",
  left), ...)
}
\arguments{
\item{data}{A data.frame.}

\item{rows}{An expression that evaluates to logical and is equal in length to
the number of rows.}

\item{columns}{A vector of either integer positions or character names
corresponding to columns that should be highlighted.  Defaults to all columns.}

\item{left}{A highlighting tag for the left side of the cell value.}

\item{right}{A highlighting tag for the right side of the cell value.
Attempts to use the \code{left} input to create a corresponding \code{right}
HTML based tag.}

\item{\ldots}{ignored.}
}
\value{
Returns a data.frame with the chosen cell values wrapped in highlight
tags.
}
\description{
A lightweight cell highlighter that uses non-standard evaluation.  This
function is designed for interactive use.  It's behavior outside of this
context is not gaurenteed.  For finer contral use an \code{ifelse} with
\code{paste} within a \code{?dplyr::mutate} statement.
}
\examples{
highlight_cells(mtcars, rows = hp > 230 | qsec > 20)
highlight_cells(mtcars, rows = hp > 230, columns = 'hp')

\dontrun{
library(dplyr); library(tibble); library(pander)
mtcars \%>\%
    highlight_cells(rows = hp > 230, columns = 'hp') \%>\%
    highlight_cells(rows = qsec > 20, columns = 'qsec', left = '<b style="color:blue;">')  \%>\%
    rownames_to_column('car') \%>\%
    data.frame(stringsAsFactors = FALSE, check.names = FALSE) \%>\%
    pander::pander(split.tables = Inf, justify = alignment(.))
}

\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load(tidyverse, magrittr)

set.seed(10)
data_frame(
    w = paste(constant_months, rep(2016:2017, each = 12))[1:20] ,
    x = rnorm(20, 200000, 75000)
) \%>\%
    {
        a <- .
        rbind(
            a,
            a \%>\%
                mutate(w = 'Total') \%>\%
                group_by(w) \%>\%
                summarize(x = sum(x))
        )
    } \%>\%
    mutate(
        y = f_denom(x, prefix = '$'),
        z = f_denom(x, mix.denom = TRUE, prefix = '$'),
        x = f_comma(f_dollar(x, 2))
    )  \%>\%
    highlight_cells(w == 'Total') \%>\%
    data.frame(stringsAsFactors = FALSE, check.names = FALSE) \%>\%
    pander::pander(split.tables = Inf, justify = alignment(.))
}
}
