% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{get_nutrientname}
\alias{get_nutrientname}
\title{get_nutrientname}
\usage{
get_nutrientname(apiKey = NULL, nutrientNameId = NULL, lang = "en")
}
\arguments{
\item{apiKey}{Key to access the API. Can be retrieved from
\url{https://hc-sc.api.canada.ca/en/detail?api=cnf#!/Nutrient/get_nutrientname}.
If none is provided, the system environment variables will be checked.}

\item{nutrientNameId}{The code indicating the food name you want to search for. If null,
all foods and their corresponding symbols and  are returned.}

\item{lang}{The language to return results in, can be either 'en' or 'fr'.}
}
\value{
A tibble containing nutrient name id, name, code, web_name and other details
}
\description{
Makes a query to the Canadian Nutrient File nutrientname endpoint. This endpoint
returns a list of all nutrient names, symbols, names, unit of measurement, nutrient group name, etc.
For instance, for nutrient name id of 810, the corresponding nutrient symbol is STAR and nutrient name is
STARCH, unit is 2 and nutrient group id is 2.
}
\examples{
\dontrun{
get_nutrientname()
get_nutrientname(nutrientNameId = 550)
get_nutrientname(nutrientNameId = 550, lang = "fr")}
}
