% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{getAnnotationLabels}
\alias{getAnnotationLabels}
\title{Gets labels of annotations on a given layer, identified by given annotation IDs.}
\usage{
getAnnotationLabels(labbcat.url, id, layerId, count = 1,
  no.progress = FALSE)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A vector of annotation IDs.}

\item{layerId}{A layer name.}

\item{count}{The number of annotations on the given layer to retrieve.}

\item{no.progress}{Optionally suppress the progress bar when
multiple fragments are  specified - TRUE for no progress bar.}
}
\value{
A data frame of labels.
}
\description{
Gets labels of annotations on a given layer, identified by given annotation IDs.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Load some search results previously exported from LaBB-CAT
results <- read.csv("results.csv", header=T)

## Get the topic annotations for the matches
topics <- getAnnotationLabels(labbcat.url, results$MatchId, "topic")
}

}
\keyword{annotation}
\keyword{label}
\keyword{layer}
