% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMatchLabels.R
\name{getMatchLabels}
\alias{getMatchLabels}
\title{Gets labels of annotations on a given layer, identified by given match IDs.}
\usage{
getMatchLabels(
  labbcat.url,
  matchIds,
  layerIds,
  targetOffset = 0,
  annotationsPerLayer = 1
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{matchIds}{A vector of annotation IDs, e.g. the MatchId column, or the URL column,
of a results set.}

\item{layerIds}{A vector of layer IDs.}

\item{targetOffset}{The distance from the original target of the match, e.g.
\itemize{
 \item{\emph{0} -- find annotations of the match target itself},
 \item{\emph{1} -- find annotations of the token immediately \emph{after} match target}
 \item{\emph{-1} -- find annotations of the token immediately \emph{before} match target}
}}

\item{annotationsPerLayer}{The number of annotations on the given layer to
retrieve. In most cases, there's only one annotation available. However, tokens
may, for example, be annotated with `all possible phonemic transcriptions', in which
case using a value of greater than 1 for this parameter provides other phonemic
transcriptions, for tokens that have more than one.}
}
\value{
A data frame of labels.
}
\description{
Gets labels of annotations on a given layer, identified by given match IDs.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Perform a search
results <- getMatches(labbcat.url, list(orthography="quake"))

## Get the topic annotations for the matches
topics <- getMatchLabels(labbcat.url, results$MatchId, "topic")
}

}
\seealso{
\code{\link{getMatches}}
\code{\link{getMatchAlignments}}
}
\keyword{annotation}
\keyword{label}
\keyword{layer}
