% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praatScriptIntensity.R
\name{praatScriptIntensity}
\alias{praatScriptIntensity}
\title{Generates a script for extracting maximum intensity, for use with \link{processWithPraat}.}
\usage{
praatScriptIntensity(minimum.pitch = 100, time.step = 0, subtract.mean = TRUE)
}
\arguments{
\item{minimum.pitch}{Minimum pitch (Hz).}

\item{time.step}{Time step in seconds, or 0.0 for 'auto'.}

\item{subtract.mean}{Whether to subtract the mean or not.}
}
\value{
A script fragment which can be passed as the praat.script parameter of
    \link{processWithPraat}
}
\description{
This function generates a Praat script fragment which can be passed as the praat.script
parameter of \link{processWithPraat}, in order to extract maximum intensity value.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Perform a search
results <- getMatches(labbcat.url, list(segment="s"))

## Get intensity for all matches
intensity <- processWithPraat(
              labbcat.url,
              results$MatchId, results$Target.segment.start, results$Target.segment.end,
              praatScriptIntensity())
}
}
\seealso{
\link{processWithPraat}

\link{praatScriptFormants}

\link{praatScriptCentreOfGravity}

\link{praatScriptPitch}

\link{praatScriptFastTrack}
}
\keyword{praat}
