% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praatScriptPitch.R
\name{praatScriptPitch}
\alias{praatScriptPitch}
\title{Generates a script for extracting pitch, for use with \link{processWithPraat}.}
\usage{
praatScriptPitch(
  get.mean = TRUE,
  get.minimum = FALSE,
  get.maximum = FALSE,
  time.step = 0,
  pitch.floor = 60,
  max.number.of.candidates = 15,
  very.accurate = FALSE,
  silence.threshold = 0.03,
  voicing.threshold = 0.5,
  octave.cost = 0.01,
  octave.jump.cost = 0.35,
  voiced.unvoiced.cost = 0.35,
  pitch.ceiling = 500,
  pitch.floor.male = 30,
  voicing.threshold.male = 0.4,
  pitch.ceiling.male = 250,
  gender.attribute = "participant_gender",
  value.for.male = "M",
  sample.points = NULL,
  interpolation = "linear",
  skip.errors = TRUE
)
}
\arguments{
\item{get.mean}{Extract the mean pitch for the sample.}

\item{get.minimum}{Extract the minimum pitch for the sample.}

\item{get.maximum}{Extract the maximum pitch for the sample.}

\item{time.step}{Step setting for praat command}

\item{pitch.floor}{Minimum pitch (Hz) for all speakers, or for female speakers,
if pitch.floor.male is also specified.}

\item{max.number.of.candidates}{Maximum number of candidates setting for praat command}

\item{very.accurate}{Accuracy setting for praat command}

\item{silence.threshold}{Silence threshold setting for praat command}

\item{voicing.threshold}{Voicing threshold (Hz) for all speakers, or for female speakers,
if voicing.threshold.male is also specified.}

\item{octave.cost}{Octave cost setting for praat command}

\item{octave.jump.cost}{Octave jump cost setting for praat command}

\item{voiced.unvoiced.cost}{Voiced/unvoiced cost setting for praat command}

\item{pitch.ceiling}{Maximum pitch (Hz) for all speakers, or for female speakers,
if pitch.floor.male is also specified.}

\item{pitch.floor.male}{Minimum pitch (Hz) for male speakers.}

\item{voicing.threshold.male}{Voicing threshold (Hz) for male speakers.}

\item{pitch.ceiling.male}{Maximum pitch (Hz) for male speakers.}

\item{gender.attribute}{Name of the LaBB-CAT participant attribute that contains the
participant's gender - normally this is "participant_gender".}

\item{value.for.male}{The value that the gender.attribute has when the participant is male.}

\item{sample.points}{A vector of numbers (0 <= sample.points <= 1) specifying multiple
points at which to take the measurement.  The default is NULL, meaning no
individual measurements will be taken (only the aggregate values identified by
get.mean, get.minimum, and get.maximum).  A single point at 0.5 means one
measurement will be taken halfway through the target interval.  If, for example, 
you wanted eleven measurements evenly spaced throughout the interval, you would
specify sample.points as being 
c(0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0).}

\item{interpolation}{If sample.points are specified, this is the interpolation to use
when getting individual values. Possible values are 'nearest' or 'linear'.}

\item{skip.errors}{Sometimes, for some segments, Praat fails to create a Pitch
object. If skip.errors = TRUE, analysis those segments will be skipped, and corresponding
pitch values will be returned as "--undefined--". If skip.errors = FALSE, the error
message from Praat will be returned in the Error field, but no pitch measures will
be returned for any segments in the same recording.}
}
\value{
A script fragment which can be passed as the praat.script parameter of
    \link{processWithPraat}
}
\description{
This function generates a Praat script fragment which can be passed as the praat.script
parameter of \link{processWithPraat}, in order to extract pitch information.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Perform a search
results <- getMatches(labbcat.url, list(segment="I"))

## Get pitch mean, max, and min, and the midpoint of the segment, for each match
pitch <- processWithPraat(
              labbcat.url,
              results$MatchId, results$Target.segment.start, results$Target.segment.end,
              praatScriptPitch(get.mean=TRUE, get.minimum=TRUE, get.maximum=TRUE,
                               sample.points = c(.5)))
}
}
\seealso{
\link{processWithPraat}

\link{praatScriptFormants}

\link{praatScriptCentreOfGravity}

\link{praatScriptIntensity}

\link{praatScriptFastTrack}
}
\keyword{praat}
