% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatTranscript.R
\name{formatTranscript}
\alias{formatTranscript}
\title{Gets transcript(s) in a given format}
\usage{
formatTranscript(
  labbcat.url,
  id,
  layer.ids,
  mime.type = "text/praat-textgrid",
  path = ""
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{The transcript ID (transcript name) of the sound recording, or
a vector of transcript IDs. If the same ID appears more than one, the formatted
file is downloaded only once.}

\item{layer.ids}{A vector of layer IDs.}

\item{mime.type}{Optional content-type - "text/praat-textgrid" is the default, but your
LaBB-CAT installation may support other formats, which can be discovered using
\link{getSerializerDescriptors}.}

\item{path}{Optional path to directory where the files should be saved.}
}
\value{
The name of the file, which is saved in the current directory, or the given
path, or a list of names of files, if multiple id's were specified.

If a list of files is returned, they are in the order that they
were returned by the server, which \emph{should} be the order that
they were specified in the id list.
}
\description{
This function gets whole transcripts from 'LaBB-CAT',
converted to a given format (by default, Praat TextGrid).
}
\details{
\strong{NB} Although many formats will generate exactly one file for each interval
(e.g. mime.type=text/praat-textgrid), this is not guaranted; some formats generate
a single file or a fixed collection of files regardless of how many IDs there are.
}
\examples{
\dontrun{
## Get the TextGrid of a recording
textgrid.file <- formatTranscript(labbcat.url, "AP2505_Nelson.eaf",
    c("word", "segment"), path="textgrids") 

## Get all the transcripts of a given participant
transcript.ids <- getTranscriptIdsWithParticipant(labbcat.url, "AP2505_Nelson")

## Download all the TextGrids, including the utterances, transcript, and segment layers
textgrid.files <- formatTranscript(
    labbcat.url, transcript.ids, c("utterance", "word", "segment"))

}
}
\seealso{
\link{getSerializerDescriptors}
}
\keyword{TextGrid}
\keyword{transcript}
