% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_normal.R
\name{conf_mat}
\alias{conf_mat}
\title{Calculate and Visualise a Confusion Matrix}
\usage{
conf_mat(N, res, plot = TRUE)
}
\arguments{
\item{N}{(numeric) number of simulations}

\item{res}{(mcmc_hmm_*) simulated MCMC HMM model}

\item{plot}{(logical) plot confusion matrix. By default \code{TRUE}}
}
\value{
\code{\link[cvms]{confusion_matrix}}
}
\description{
A diagnostic function that tests the reliability of estimation
procedures given the inferred transition rates
}
\details{
First the data is simulated given the inferred model parameters and transition
rates. Then posterior probabilities are calculated and states are inferred.
Finally, the inferred states and simulated states are compared via
\code{\link[cvms]{confusion_matrix}} function.
}
\examples{
res <- conf_mat(100, example_hmm_mcmc_normal, plot = TRUE) 
}
