% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_normal.R
\name{convert_to_ggmcmc}
\alias{convert_to_ggmcmc}
\title{Converts MCMC Samples into \code{ggmcmc} Format}
\usage{
convert_to_ggmcmc(
  x,
  pattern = c("mean", "sigma", "beta", "alpha", "pois_means", "T"),
  include_warmup = FALSE
)
}
\arguments{
\item{x}{(mcmc_hmm_*) MCMC HMM object}

\item{pattern}{(character) pattern(s) with model parameters to be included in the output}

\item{include_warmup}{(logical) include warmup samples. By default \code{FALSE}}
}
\value{
data.frame compatible with functions from the \code{ggmcmc} package
}
\description{
This helper function converts MCMC samples into \code{ggmcmc} format
}
\details{
By default, for a given model, all parameters are converted into ggmcmc format.

The parameter \code{pattern} can be used to extract specific parameters.
For instance \code{pattern="mean"} extracts all mean parameters from 
a hmm_mcmc_normal model.

If a specific parameter is of interest it can be matched by an exact name:
\code{pattern=c("mean[1]", "T[1,1]")}.
}
\examples{
# Convert all parameters (Normal model)
convert_normal_all <- convert_to_ggmcmc(example_hmm_mcmc_normal)
unique(convert_normal_all$Parameter)
head(convert_normal_all)
tail(convert_normal_all)

# Convert only means (Normal model)
convert_normal_means <- convert_to_ggmcmc(example_hmm_mcmc_normal, 
                                          pattern = "mean")
unique(convert_normal_means$Parameter)

# Convert selected parameter (Normal model)
pattern_normal <- c("mean[1]", "sigma[1]", "T[1,1]")
convert_normal_param <- convert_to_ggmcmc(example_hmm_mcmc_normal, 
                                          pattern = pattern_normal)
unique(convert_normal_param$Parameter)

# Convert all parameters (Poisson-Gamma model)
convert_pois_gamma_all <- convert_to_ggmcmc(example_hmm_mcmc_gamma_poisson)
unique(convert_pois_gamma_all$Parameter)
}
