% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_normal.R
\name{eigen_system}
\alias{eigen_system}
\title{Calculate Eigenvalues and Eigenvectors}
\usage{
eigen_system(mat)
}
\arguments{
\item{mat}{(matrix) a square matrix}
}
\value{
a list with three elements:
\itemize{
\item \code{lambda}: eigenvalues
\item \code{forwards}: left eigenvector
\item \code{backwards}: right eigenvector
}
}
\description{
This helper function returns the eigenvalues in lambda and the left and right eigenvectors in forwards and backwards
}
\examples{
mat_T0 <- rbind(c(1-0.01,0.01,0),
               c(0.01,1-0.02,0.01),
               c(0,0.01,1-0.01))
eigen_system(mat_T0)
}
