% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_poisson.R
\name{plot.hmm_mcmc_gamma_poisson}
\alias{plot.hmm_mcmc_gamma_poisson}
\title{Plot Diagnostics for \code{hmm_mcmc_gamma_poisson} Objects}
\usage{
\method{plot}{hmm_mcmc_gamma_poisson}(
  x,
  simulation = FALSE,
  true_betas = NULL,
  true_alpha = NULL,
  true_mat_T = NULL,
  true_states = NULL,
  show_titles = TRUE,
  log_statesplot = FALSE,
  ...
)
}
\arguments{
\item{x}{(hmm_mcmc_gamma_poisson) HMM MCMC gamma-poisson object}

\item{simulation}{(logical); default is \code{simulation=FALSE}, so the input data was empirical. If the input data was simulated, it must be set \code{simulation=TRUE}.}

\item{true_betas}{(numeric) true betas. To be used if \code{simulation=TRUE}}

\item{true_alpha}{(numeric) true alpha. To be used if \code{simulation=TRUE}}

\item{true_mat_T}{(matrix) \code{optional parameter}; true transition matrix. To be used if \code{simulation=TRUE}}

\item{true_states}{(integer) \code{optional parameter}; true states. To be used if \code{simulation=TRUE}}

\item{show_titles}{(logical) if \code{TRUE} then titles are shown for all graphs. By default, \code{TRUE}}

\item{log_statesplot}{(logical) if \code{TRUE} then log-statesplots are shown. By default, \code{FALSE}}

\item{...}{not used}
}
\value{
Several diagnostic plots that can be used to evaluate the MCMC simulation
of the gamma-poisson HMM
}
\description{
This function creates a variety of diagnostic plots that can be useful when 
conducting Markov Chain Monte Carlo (MCMC) simulation of a gamma-poisson hidden Markov model (HMM). 
These plots will help to assess convergence, fit, and performance of the MCMC simulation
}
\examples{
\donttest{
plot(example_hmm_mcmc_gamma_poisson)
}
}
