% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_providers.R
\name{update_providers}
\alias{update_providers}
\title{Update the locally stored OAI-PMH data providers table.}
\usage{
update_providers(path = ".", ...)
}
\arguments{
\item{path}{Path to put data in.}

\item{...}{Curl options passed on to \code{\link[httr:GET]{httr::GET()}}}
}
\description{
Data comes from
\url{http://www.openarchives.org/Register/BrowseSites}. It includes the
oai-identifier (if they have one) and the base URL. The website has
the name of the data provider too, but not provided in the data pulled
down here, but you can grab the name using the example below.
}
\details{
This table is scraped from
\url{http://www.openarchives.org/Register/BrowseSites}.
I would get it from \url{http://www.openarchives.org/pmh/registry/ListFriends},
but it does not include repository names.

This function updates the table for you. Does take a while though, so
go get a coffee.
}
\examples{
\dontrun{
update_providers()
load_providers()
}
}
\seealso{
\code{\link[=load_providers]{load_providers()}}
}
