% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{flatten}
\alias{flatten}
\alias{flatten.rtree}
\title{Flatten a tree}
\usage{
flatten(.tree)

\method{flatten}{rtree}(.tree)
}
\arguments{
\item{.tree}{A tree to be flattened.}
}
\value{
A (possibly empty) list of nodes.
}
\description{
The function \code{flatten} returns all the 
nodes that compose a given tree.
}
\examples{
## Rooted tree
(tr0 = c_("Bob", "Carl", "Daniel"))
(tr1 = c_("Bill", "Caroline", "Dimitri", "Enoc"))
(tr2 = r_("Alice", s = list(tr0, tr1)))
flatten(tr2)

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son"))))
flatten(tr3)

}
