% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plotCurrentDepth}
\alias{plotCurrentDepth}
\title{Visualise order book depth at any given point in time.}
\usage{
plotCurrentDepth(order.book, volume.scale = 1, show.quantiles = T,
  show.volume = T)
}
\arguments{
\item{order.book}{A limit \code{\link{orderBook}} structure.}

\item{volume.scale}{Volume scale factor.}

\item{show.quantiles}{If true, highlight top 1\% highest volume.}

\item{show.volume}{If true, also show non-cumulative volume.}
}
\description{
Plots the cumalative volume on each side of the limit order book.
}
\examples{

# get a limit order book for a specific point in time, limited to +- 150bps
# above/below best bid/ask price.
lob <- orderBook(lob.data$events,
    tp=as.POSIXct("2015-05-01 04:38:17.429", tz="UTC"), bps.range=150)

# visualise the order book liquidity.
plotCurrentDepth(lob, volume.scale=10^-8)

}
\author{
phil
}

