% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevGBIFdownload.R
\name{prevGBIFdownload}
\alias{prevGBIFdownload}
\title{Download previously-prepared GBIF data sets}
\usage{
prevGBIFdownload(taxonKey = "No key", GBIFLogin)
}
\arguments{
\item{taxonKey}{A taxon key as returned from `rgbif::name_suggest()`.}

\item{GBIFLogin}{An object of class \code{\link{GBIFLogin}} to log in to
GBIF to begin the download.}
}
\value{
A GBIF download key, if one is available
}
\description{
Searches the list of a user's most recent 1000 downloads
on the GBIF servers and returns the data set key for the most recently
prepared download.
}
\examples{
\dontrun{
GBIFLogin <- GBIFLoginManager(user = "theWoman",
               email = "ireneAdler@laScala.org",
               pwd = "sh3r")
taxKey <- rgbif::name_suggest(q= "Protea cynaroides", rank='species')$key[1]
prevGBIFdownload(taxonKey = taxKey,
              GBIFLogin = myGBIFLogin)
}

}
