% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_occ_uncertain.R
\name{generate_occ_uncertain}
\alias{generate_occ_uncertain}
\title{Random latitude and longitude coordinates accounting uncertainty values}
\usage{
generate_occ_uncertain(
  occs_df,
  lat_col = "latitude",
  lon_col = "longitude",
  lat_uncertainty = "latitude_uncertainty",
  lon_uncertainty = "longitude_uncertainty",
  taxa_col = "species"
)
}
\arguments{
\item{occs_df}{A \code{data.frame} of occurrence locations that includes
\emph{at least these four columns} - latitude, longitude, latitude uncertainty and longitude uncertainty in degrees.}

\item{lat_col}{Name of column of latitude dbl values. Caps sensitive.}

\item{lon_col}{Name of column of longitude dbl values. Caps sensitive.}

\item{lat_uncertainty}{Name of column of latitude uncertainty in degree values. Caps sensitive.}

\item{lon_uncertainty}{Name of column of longitude uncertainty in degree values. Caps sensitive.}

\item{taxa_col}{Name of column of taxa (species) values. Caps sensitive.}
}
\value{
random_dd A \code{data.frame} of a random latitude, random longitude and taxa name for each occurence record.
}
\description{
\code{generate_occ_uncertain} Given a data frame of georeferenced occurrences this function generates a new set of coordinates with added uncertainty.
}
\details{
\strong{Input} as a \code{dataframe} should have the following structure:
\tabular{ccccc}{ 
[,1] \tab ddlat \tab numeric, latitude (in decimal degrees)\cr 
[,2] \tab ddlon \tab numeric, longitude (in decimal degrees)\cr
[,3] \tab ddlat unc \tab numeric, longitude uncertainty (in decimal degrees)\cr
[,4] \tab ddlon unc \tab numeric, longitude uncertainty (in decimal degrees)\cr
[,5] \tab tax \tab character or factor, taxa names\cr}
\strong{It is mandatory to respect field positions, but field names do not
matter}
}
