% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occumbData.R
\name{occumbData}
\alias{occumbData}
\title{Constructor for occumbData data class.}
\usage{
occumbData(y, spec_cov = NULL, site_cov = NULL, repl_cov = NULL)
}
\arguments{
\item{y}{A 3-D array of sequence read counts (\code{integer} values) that may
have a \code{dimnames} attribute.
Dimensions are ordered by species, site, and replicate.
Data for missing replicates must be represented by zero vectors.
\code{NA}s are not allowed.}

\item{spec_cov}{A named list of species covariates.
Each covariate can be a vector of continuous (\code{numeric}
or \code{integer}) or discrete (\code{logical},
\code{factor}, or \code{character}) variables whose length
equals \code{dim(y)[1]} (i.e., the number of species).
\code{NA}s are not allowed.}

\item{site_cov}{A named list of site covariates.
Each covariate can be a vector of continuous (\code{numeric}
or \code{integer}) or discrete (\code{logical},
\code{factor}, or \code{character}) variables whose length
equals \code{dim(y)[1]} (i.e., the number of sites).
\code{NA}s are not allowed.}

\item{repl_cov}{A named list of replicate covariates.
Each covariate can be a matrix of continuous (\code{numeric}
or \code{integer}) or discrete (\code{logical} or
\code{character}) variables whose dimension equals
\code{dim(y)[2:3]} (i.e., the number of sites \eqn{\times}{*}
number of replicates).
\code{NA}s are not allowed.}
}
\value{
An S4 object of the \code{occumbData} class.
}
\description{
\code{occumbData()} creates a data list compatible with the model-fitting
function \code{\link{occumb}()}.
}
\details{
The element (i.e., covariate) names for \code{spec_cov}, \code{site_cov}, and
\code{repl_cov} must all be unique.
If \code{y} has a \code{dimnames} attribute, it is retained in the resulting
\code{occumbData} object and can be referenced in subsequent analyses.
}
\examples{
# Generate the smallest random dataset (2 species * 2 sites * 2 reps)
I <- 2 # Number of species
J <- 2 # Number of sites
K <- 2 # Number of replicates
data <- occumbData(
    y = array(sample.int(I * J * K), dim = c(I, J, K)),
    spec_cov = list(cov1 = rnorm(I)),
    site_cov = list(cov2 = rnorm(J), cov3 = factor(1:J)),
    repl_cov = list(cov4 = matrix(rnorm(J * K), J, K))
)

# A case for named y (with species and site names)
y_named <- array(sample.int(I * J * K), dim = c(I, J, K))
dimnames(y_named) <- list(c("common species", "uncommon species"),
                          c("good site", "bad site"), NULL)
data_named <- occumbData(
    y = y_named,
    spec_cov = list(cov1 = rnorm(I)),
    site_cov = list(cov2 = rnorm(J), cov3 = factor(1:J)),
    repl_cov = list(cov4 = matrix(rnorm(J * K), J, K))
)

# A real data example
data(fish_raw)
fish <- occumbData(
    y = fish_raw$y,
    spec_cov = list(mismatch = fish_raw$mismatch),
    site_cov = list(riverbank = fish_raw$riverbank)
)

# Get an overview of the datasets
summary(data)
summary(data_named)
summary(fish)
}
