% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggestions.R
\name{get_job_suggestions}
\alias{get_job_suggestions}
\title{Make coding suggestions based on a user's open-ended text input.}
\usage{
get_job_suggestions(
  text,
  suggestion_type = "auxco-1.2.x",
  num_suggestions = 5,
  suggestion_type_options = list(),
  aggregate_score_threshold = 0.02,
  item_score_threshold = 0,
  distinctions = TRUE,
  steps = list(simbased_wordwise = list(algorithm = algo_similarity_based_reasoning,
    parameters = list(sim_name = "wordwise")), simbased_substring = list(algorithm =
    algo_similarity_based_reasoning, parameters = list(sim_name = "substring"))),
  include_general_id = FALSE
)
}
\arguments{
\item{text}{The raw text input from the user.}

\item{suggestion_type}{Which type of suggestion to use / provide.
Possible options are "auxco-1.2.x" and "kldb-2010".}

\item{num_suggestions}{The maximum number of suggestions to show.
This is an upper bound and less suggestions may be returned.
Defaults to 5.}

\item{suggestion_type_options}{A list with options for generating
suggestions. Supported options:
- \code{datasets}: Pass specific datasets to be used whenn adding information
to predictions e.g. use a specific version of the kldb or auxco.
Supported datasets are: "auxco-1.2.x", "kldb-2010". By default the datasets
bundled with this package are used.}

\item{aggregate_score_threshold}{A single value or named list of thresholds
between 0 and 1. If it is a list, each entry should correspond to one of
the \code{steps}. If it is a single value, it will apply to all steps.
Results from that step will only be returned if the sum of
their scores is equal to or greater than the specified threshold. With a
aggregate_score_threshold of 0 results will always be returned
(if there are any).}

\item{item_score_threshold}{A threshold between 0 and 1 (usually
very small, default 0). Results from any step will only be returned if they
are greater than the specified threshold. Allows the removal of highly
implausible suggestions.}

\item{distinctions}{Whether or not to add additional distinctions to
similar occupational categories to the source code.
Defaults to TRUE.}

\item{steps}{A list with the algorithms to use and their parameters. Each
entry of the list should contain a nested list with two entries:
algorithm (the algorithm's function itself) and parameters (the parameters
to pass onto the algorithm). Each algorithm will also always have access
to a default set of three parameters:
\itemize{
\item text_processed: The input text after preprocessing
\item suggestion_type: Which type of suggestion to output
\item num_suggestions: How many suggestions shall be returned
These parameters must not be specified manually and will be provided
automatically instead.
Defaults to:
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
  # try similarity "one word at most 1 letter different" first
  list(
    algorithm = algo_similarity_based_reasoning,
    parameters = list(
      sim_name = "wordwise",
      min_aggregate_prob = 0.535
    )
  ),
  # since everything else failed, try "substring" similarity
  list(
    algorithm = algo_similarity_based_reasoning,
    parameters = list(
      sim_name = "substring",
      min_aggregate_prob = 0.02
    )
  )
)
}\if{html}{\out{</div>}}}

\item{include_general_id}{Whether a general column, called "id" should always
be returned. This will automatically contain the appropriate id for
different suggestion_types i.e. for "auxco-1-2.x" it will contain the same
data as the column "auxco_id".}
}
\value{
A data.table with suggestions or NULL if no suggestions were found.
}
\description{
Given a \code{text} input, find up to \code{num_suggestions} possible occupation categories.
}
\details{
The procedure implemented here is, roughly speaking, as follows:
\enumerate{
\item Predict categories from KldB 2010, including their scores. The first algorithm mentioned in \code{steps} is used (default: \code{\link[=algo_similarity_based_reasoning]{algo_similarity_based_reasoning()}}).
\item Convert the predicted KldB 2010 categories to \code{suggestion_type} (default: \verb{auxco-1.2.x}, an n:m mapping, scores are mapped accordingly.). See internal function \code{convert_suggestions()} for details.
\item Remove predicted categories if their score is below \code{item_score_threshold} and only keep the \code{num_suggestions} top-ranked suggestions.
\item Start anew, trying the next algorithm in \code{steps}, if the the top-ranked suggestions have a low chance to be correct. (Technically, this happens if the summed score of the \code{num_suggestions} top-ranked suggestions is below \code{aggregate_score_threshold}.)
\item If \code{suggestion_type == "auxco-1.2.x"} and \code{distinctions == TRUE}, insert additional and (highly) similar categories or replace existing ones. See internal function \code{add_distinctions_auxco()}. Reorder and keep only the \code{num_suggestions} top-ranked suggestions. Auxco categories which were added during this step can be identified by their scores: It equals 0.05 for categories with high similarity and 0.005 for categories with medium similarity.
}
}
\examples{
\dontshow{data.table::setDTthreads(1)}

\dontrun{
if (interactive()) {
  get_job_suggestions("Koch")
}

if (interactive()) {
  get_job_suggestions("Schlosser")
}
}
}
