% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{load_kldb_raw}
\alias{load_kldb_raw}
\alias{load_kldb}
\title{Clean & Load KldB 2010 dataset.}
\usage{
load_kldb_raw(
  cache_dir = getOption("occupationMeasurement.cache_dir", tempdir())
)

load_kldb(cache_dir = getOption("occupationMeasurement.cache_dir", tempdir()))
}
\arguments{
\item{cache_dir}{The path to the directory where the downloaded data should be stored.
We recommend setting this to "cache" to store data in the working directory. This
will prevent reloading the data time and time again. This can be set globally via
\code{options(occupationMeasurement.cache_dir = "cache")}.}
}
\value{
A cleaned / slimmed version of the KldB 2010.
}
\description{
Use load_kldb_raw() to load the whole dataset.
}
\details{
Source: https://www.klassifikationsserver.de/klassService/index.jsp?variant=kldb2010

More information on the KldB 2010: https://statistik.arbeitsagentur.de/DE/Navigation/Grundlagen/Klassifikationen/Klassifikation-der-Berufe/KldB2010-Fassung2020/KldB2010-Fassung2020-Nav.html The KldB 2010 has been revised in 2020. These changes have not been implemented here yet.
}
\section{Functions}{
\itemize{
\item \code{load_kldb_raw()}: Load raw KldB 2010 dataset.

}}
\examples{
\dontshow{data.table::setDTthreads(1)}

\dontrun{
# We recommend using a non-temporary directory for caching, so data is
# downloaded only once and not time and time again
cache_dir <- tempdir()
# Note: The dataset will be downloaded from the internet
# Load the cleaned dataset
load_kldb(cache_dir = cache_dir)
# Load the raw dataset
load_kldb_raw(cache_dir = cache_dir)
}
}
