\name{plot.gps}

\alias{plot.gps}
\alias{plot,gps,missing-method}
\alias{plot,gps-method}

\title{Plot a gps object}

\description{Plot a gps object}

\usage{\S4method{plot}{gps}(x,
     xlab="", ylab="",
     asp,
     clongitude, clatitude, span,
     projection, parameters=NULL, orientation=NULL,
     expand=1,
     mgp=getOption("oceMgp"), 
     mar=c(mgp[1]+1,mgp[1]+1,1,1),
     bg,
     axes=TRUE, cex.axis=par('cex.axis'),
     add=FALSE, inset=FALSE,
     geographical=0,
     debug=getOption("oceDebug"),
     \dots)}

\arguments{
  \item{x}{A \code{gps} object, as read by
    \code{\link{read.gps}} or created by
    \code{\link{as.gps}}, or a list containing items named
    \code{longitude} and \code{latitude}.} 
  \item{xlab}{label for x axis}
  \item{ylab}{label for y axis}
  \item{asp}{Aspect ratio for plot.  The default is for \code{plot.gps}
      to set the aspect ratio to give natural latitude-longitude scaling
      somewhere near the centre latitude on the plot. Often, it makes sense to
      set \code{asp} yourself, e.g. to get correct shapes at 45N, use
      \code{asp=1/cos(45*pi/180)}.  Note that the land mass is not symmetric
      about the equator, so to get good world views you should set \code{asp=1}
      or set \code{ylim} to be symmetric about zero. Any given value of
      \code{asp} is ignored, if \code{clongitude} and \code{clatitude} are
      given.}
  \item{clongitude,clatitude}{optional center latitude of map, in decimal
      degrees.  If both \code{clongitude} and \code{clatitude} are provided,
      then any provided value of \code{asp} is ignored, and instead the plot
      aspect ratio is computed based on the center latitude.  If
      \code{clongitude} and \code{clatitude} are provided, then \code{span}
      must also be provided.}
  \item{span}{optional suggested span of plot, in kilometers.  The suggestion
      is an upper limit on the scale; depending on the aspect ratio of the
      plotting device, the radius may be smaller than \code{span}.  A value for
      \code{span} must be supplied, if \code{clongitude} and \code{clatitude}
      are supplied.}

  \item{projection}{optional map projection to use (see \code{\link{mapPlot}});
      if not given, a cartesian frame is used, scaled so that gps shapes
      near the centre of the plot are preserved.  If a projection is provided,
      the coordinate system will bear an indirect relationship to longitude and
      longitude, and further adornment of the plot must be done with
      e.g.  \code{\link{mapPoints}} instead of \code{\link{points}}.}
  
  \item{parameters}{optional parameters to map projection (see
      \code{\link{mapPlot}}.}

  \item{orientation}{optional orientation of map projection (see
      \code{\link{mapPlot}}.}

  \item{expand}{numerical factor for the expansion of plot limits,
    showing area outside the plot, e.g. if showing a ship track as a
    gps, and then an actual gps to show the ocean boundary.
    The value of \code{expand} is ignored if either \code{xlim} or
    \code{ylim} is given.}
  \item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and
    also for \code{par(mar)}, computed from this.  The default is
    tighter than the R default, in order to use more space for the
    data and less for the axes.}
  \item{mar}{value to be used with \code{\link{par}("mar")}.}
  \item{bg}{optional colour to be used for the background of the map.
    This comes in handy for drawing insets (see \dQuote{details}).}
  \item{axes}{boolean, set to \code{TRUE} to plot axes.}
  \item{cex.axis}{value for axis font size factor.}
  \item{add}{boolean, set to \code{TRUE} to draw the gps on an existing
      plot.  Note that this retains the aspect ratio of that existing plot, so
      it is important to set that correctly, e.g. with \code{asp=1/cos(lat * pi
          / 180)}, where \code{clat} is the central latitude of the plot.}
  \item{inset}{set to \code{TRUE} for use within \code{\link{plotInset}}.  The
      effect is to prevent the present function from adjusting margins, which
      is necessary because margin adjustment is the basis for the method
      used by \code{\link{plotInset}}.}
  \item{geographical}{flag indicating the style of axes.  If
      \code{geographical=0}, the axes are conventional, with decimal degrees as
      the unit, and negative signs indicating the southern and western
      hemispheres.  If \code{geographical=1}, the signs are dropped, with axis
      values being in decreasing order within the southern and western
      hemispheres.  If \code{geographical=2}, the signs are dropped and the
      axes are labelled with degrees, minutes and seconds, as appropriate.}
  \item{debug}{set to \code{TRUE} to get debugging information during
    processing.}
  \item{\dots}{optional arguments passed to plotting functions.  For
    example, set \code{yaxp=c(-90,90,4)} for a plot extending from pole
    to pole.}
}

\details{This function plots a gps object.  An attempt is made to use the whole
    space of the plot, and this is done by limiting either the longitude range
    or the latitude range, as appropriate, by modifying the eastern or northern
    limit, as appropriate.

  To get an inset map inside another map, draw the first map, do
  \code{par(new=TRUE)}, and then call \code{plot.gps} with a value of
  \code{mar} that moves the inset plot to a desired location on the existing
  plot, and with \code{bg="white"}.}

\value{None.}

\seealso{The documentation for \code{\link{gps-class}} explains the structure
    of gps objects, and also outlines the other functions dealing with them.}

\examples{
\dontrun{
library(oce)
gps <- read.oce("~/Dropbox/dalwhoi.gpx")
plot(gps)
lines(coastlineWorld[["longitude"]], coastlineWorld[["latitude"]])
}
}

\author{Dan Kelley}

\keyword{hplot}
