% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\name{read.amsr}
\alias{read.amsr}
\title{Read an amsr File}
\usage{
read.amsr(file, debug = getOption("oceDebug"))
}
\arguments{
\item{file}{Sting indicating the name of a compressed file.}

\item{debug}{A debugging flag, integer.}
}
\description{
Read a compressed amsr file, generating an object that inherits from
\code{\link{amsr-class}}.  Note that only compressed files are read in
this version
}
\examples{
\dontrun{
d <- read.amsr("f34_20160102v7.2.gz")
summary(d)
plot(d, "SST", col=oceColorsJet, xlim=c(-80,0), ylim=c(20,60), asp=asp)
}
}
\author{
Dan Kelley and Chantelle Layton
}
\seealso{
\code{\link{plot.amsr}} for an example.

Other functions dealing with satellite data: \code{\link{[[,landsat-method}},
  \code{\link{amsr-class}}, \code{\link{g1sst-class}},
  \code{\link{landsatAdd}}, \code{\link{landsatTrim}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,landsat-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{read.g1sst}}, \code{\link{read.landsat}},
  \code{\link{satellite-class}},
  \code{\link{summary,amsr-method}},
  \code{\link{summary,landsat-method}},
  \code{\link{summary,satellite-method}}
}
\concept{
satellite
}

