% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{as.section}
\alias{as.section}
\title{Create a Section}
\usage{
as.section(salinity, temperature, pressure, longitude, latitude, station,
  sectionId = "")
}
\arguments{
\item{salinity}{This may be a numerical vector, in which case it is interpreted
as the salinity, and the other arguments are used for the other components of
\code{\link{ctd-class}} objects. Alternatively, it may be one of a variety of
other objects from which the CTD objects can be inferred, in which case the
other arguments are ignored; see \sQuote{Details}.}

\item{temperature}{Temperature, in a vector holding values for all stations.}

\item{pressure}{Pressure, in a vector holding values for all stations.}

\item{longitude}{Longitude, in a vector holding values for all stations.}

\item{latitude}{Latitude, in a vector holding values for all stations.}

\item{station}{Station identifiers, in a vector holding values for all stations.}

\item{sectionId}{Section identifier.}
}
\value{
An object of \code{\link{section-class}}.
}
\description{
Create a section based on columnar data, or a set of \code{\link{oce-class}}
objects that can be coerced to CTD form with \code{\link{as.ctd}}.

If the first argument is a numerical vector, then it is taken to be the
salinity, and \code{\link{factor}} is applied to \code{station} to break the
data up into chunks that are assembled into \code{\link{ctd-class}} objects with
\code{\link{as.ctd}} and combined to make a \code{\link{section-class}} object
to be returned. This mode of operation is provided as a convenience for datasets
that are already partly processed; if original CTD data are available, the next
mode is preferred, because it permits the storage of much more data and metadata
in the CTD object.

If the first argument is a list containing oce objects that can be coerced into
CTD form with \code{\link{as.ctd}} -- or a character vector containing the names
of such objects that are defined in the calling environment -- then those
objects are combined to form the station, and all other arguments are ignored.
This is the best way to call \code{as.section}.

If the first argument is a \code{\link{argo-class}} object, then the profiles it
contains are turned into \code{\link{ctd-class}} object, and these are assembled
into a section to be returned.
}
\examples{
library(oce)
data(ctd)
## vector of names of CTD objects
fake <- ctd
fake[["temperature"]] <- ctd[["temperature"]] + 0.5
fake[["salinity"]] <- ctd[["salinity"]] + 0.1
fake[["longitude"]] <- ctd[["longitude"]] + 0.01
fake[["station"]] <- "fake"
sec1 <- as.section(c("ctd", "fake"))
summary(sec1)
## vector of CTD objects
ctds <- vector("list", 2)
ctds[[1]] <- ctd
ctds[[2]] <- fake
sec2 <- as.section(ctds)
summary(sec2)
## argo data (a subset)
data(argo)
sec3 <- as.section(subset(argo, profile<5))
summary(sec3)

}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{section} data: \code{\link{[[,section-method}},
  \code{\link{[[<-,section-method}},
  \code{\link{handleFlags,section-method}},
  \code{\link{plot,section-method}},
  \code{\link{read.section}}, \code{\link{section-class}},
  \code{\link{sectionAddStation}},
  \code{\link{sectionGrid}}, \code{\link{sectionSmooth}},
  \code{\link{sectionSort}}, \code{\link{section}},
  \code{\link{subset,section-method}},
  \code{\link{summary,section-method}}
}

