% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.R
\docType{data}
\name{cm}
\alias{cm}
\title{A CM Record}
\usage{
data(cm)
}
\description{
The result of using \code{\link{read.cm}} on a current meter file holding measurements made with an
InterOcean S4 device.  See \code{\link{read.cm}} for some general cautionary notes on reading such
files, and be aware that the salinities in this sample dataset are known to be incorrect, for
unknown reasons perhaps related to lack of calibration of an old instrument that is seldom used.
}
\examples{
\dontrun{
library(oce)
data(cm)
summary(cm)
plot(cm)
}
}
\seealso{
Other datasets provided with \code{oce}: \code{\link{adp}},
  \code{\link{adv}}, \code{\link{argo}},
  \code{\link{coastlineWorld}}, \code{\link{colors}},
  \code{\link{ctdRaw}}, \code{\link{ctd}},
  \code{\link{echosounder}}, \code{\link{landsat}},
  \code{\link{lisst}}, \code{\link{lobo}},
  \code{\link{met}}, \code{\link{rsk}},
  \code{\link{sealevelTuktoyaktuk}},
  \code{\link{sealevel}}, \code{\link{section}},
  \code{\link{topoWorld}}, \code{\link{wind}}

Other things related to \code{cm} data: \code{\link{[[,cm-method}},
  \code{\link{[[<-,cm-method}}, \code{\link{cm-class}},
  \code{\link{plot,cm-method}}, \code{\link{read.cm}},
  \code{\link{subset,cm-method}},
  \code{\link{summary,cm-method}}
}

