% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{methods}
\name{subset,oce-method}
\alias{subset,oce-method}
\title{Subset an oce Object}
\usage{
\S4method{subset}{oce}(x, subset, ...)
}
\arguments{
\item{x}{An oce object.}

\item{subset}{A logical expression indicating how to take the subset; the form depends on the sub-class.}

\item{...}{Ignored.}
}
\value{
An oce object.
}
\description{
This is a basic class for general oce objects.  It has specialised
versions for most sub-classes, e.g. \code{\link{subset,ctd-method}} 
for \code{ctd} objects.
}
\examples{
library(oce)
data(ctd)
# Select just the top 10 metres (pressure less than 10 dbar)
top10 <- subset(ctd, pressure < 10)
par(mfrow=c(1, 2))
plotProfile(ctd)
plotProfile(top10)
}

