% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sealevel.R
\docType{methods}
\name{subset,sealevel-method}
\alias{subset,sealevel-method}
\title{Subset a Sealevel Object}
\usage{
\S4method{subset}{sealevel}(x, subset, ...)
}
\arguments{
\item{x}{A \code{sealevel} object, i.e. one inheriting from \code{\link{sealevel-class}}.}

\item{subset}{a condition to be applied to the \code{data} portion of
\code{x}.}

\item{\dots}{ignored.}
}
\value{
A new \code{sealevel} object.
}
\description{
This function is somewhat analogous to \code{\link{subset.data.frame}}, but
subsetting is only permitted by time.
}
\examples{
library(oce)
data(sealevel)
plot(sealevel)
plot(subset(sealevel, time < mean(range(sealevel[['time']]))))

}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{sealevel} data: \code{\link{[[,sealevel-method}},
  \code{\link{[[<-,sealevel-method}},
  \code{\link{as.sealevel}},
  \code{\link{plot,sealevel-method}},
  \code{\link{read.sealevel}},
  \code{\link{sealevel-class}},
  \code{\link{sealevelTuktoyaktuk}},
  \code{\link{sealevel}},
  \code{\link{summary,sealevel-method}}
}

