% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\docType{data}
\name{ctdRaw}
\alias{ctdRaw}
\title{Seawater CTD Profile, Without Trimming of Extraneous Data}
\usage{
data(ctdRaw)
}
\description{
This is sample CTD profile provided for testing.  It includes not just the
(useful) portion of the dataset during which the instrument was being lowered,
but also data from the upcast and from time spent near the surface.  Spikes are
also clearly evident in the pressure record.  With such real-world wrinkles,
this dataset provides a good example of data that need trimming with
\code{\link{ctdTrim}}.
}
\details{
This station was sampled by students enrolled in the Dan Kelley's
Physical Oceanography class at Dalhousie University.
The data were acquired near the centre of the Bedford Basin of the
Halifax Harbour, during an October 2003 field trip of Dalhousie University's
Oceanography 4120/5120 class. The original \code{.cnv} data file had
temperature in the IPTS-68 scale, but this was converted to the more modern
scale using \code{\link{T90fromT68}}.
}
\seealso{
A similar dataset (trimmed to the downcast) is available as
\code{\link{ctd}}.

Other datasets provided with \code{oce}: \code{\link{adp}},
  \code{\link{adv}}, \code{\link{argo}}, \code{\link{cm}},
  \code{\link{coastlineWorld}}, \code{\link{colors}},
  \code{\link{ctd}}, \code{\link{echosounder}},
  \code{\link{landsat}}, \code{\link{lisst}},
  \code{\link{lobo}}, \code{\link{met}}, \code{\link{rsk}},
  \code{\link{sealevelTuktoyaktuk}},
  \code{\link{sealevel}}, \code{\link{section}},
  \code{\link{topoWorld}}, \code{\link{wind}}

Other things related to \code{ctd} data: \code{\link{[[,ctd-method}},
  \code{\link{[[<-,ctd-method}}, \code{\link{as.ctd}},
  \code{\link{cnvName2oceName}}, \code{\link{ctd-class}},
  \code{\link{ctdDecimate}}, \code{\link{ctdFindProfiles}},
  \code{\link{ctdTrim}}, \code{\link{ctd}},
  \code{\link{handleFlags,ctd-method}},
  \code{\link{plot,ctd-method}}, \code{\link{plotProfile}},
  \code{\link{plotScan}}, \code{\link{plotTS}},
  \code{\link{read.ctd.itp}}, \code{\link{read.ctd.odf}},
  \code{\link{read.ctd.sbe}},
  \code{\link{read.ctd.woce.other}},
  \code{\link{read.ctd.woce}}, \code{\link{read.ctd}},
  \code{\link{subset,ctd-method}},
  \code{\link{summary,ctd-method}},
  \code{\link{woceNames2oceNames}}, \code{\link{write.ctd}}
}

