% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapMeridians}
\alias{mapMeridians}
\title{Add Meridians on a Map [deprecated]}
\usage{
mapMeridians(latitude, lty = "solid", lwd = 0.5 * par("lwd"),
  col = "darkgray", ...)
}
\arguments{
\item{latitude}{either a logical value indicating whether to draw
a meridian grid, or a vector of latitudes at which to draw meridians.}

\item{lty}{line type.}

\item{lwd}{line width.}

\item{col}{line colour.}

\item{...}{optional arguments passed to \code{\link{lines}}.}
}
\description{
\strong{WARNING:} This function will be removed soon; see \link{oce-deprecated}.
Use \code{\link{mapGrid}} instead of the present function.
}
\details{
Plot meridians (lines of constant latitude) on an existing map.


Meridians that will not fit in the plotting space are ignored.
}
\section{Bugs}{

This should use \code{\link{approx}} to fill in multiple
segments within the line, so that e.g. great circle lines will be curved.
}
\examples{
\dontrun{
library(oce)
data(coastlineWorld)
longitude <- coastlineWorld[['longitude']]
latitude <- coastlineWorld[['latitude']]
mapPlot(longitude, latitude, type='l',
longitudelim=c(-130,-50), latitudelim=c(30,60),
proj="polyconic", orientation=c(90, -90, 0))
mapMeridians()
}

}
\author{
Dan Kelley
}
\seealso{
A map must first have been created with \code{\link{mapPlot}}.

Other functions that will be removed soon: \code{\link{addColumn}},
  \code{\link{ctdAddColumn}},
  \code{\link{ctdUpdateHeader}}, \code{\link{mapZones}}
}

